import pandas as pd
from src.stats import compute_all_stats, monthly_table

def test_monthly_table_basic():
    df = pd.DataFrame({
        "date": pd.to_datetime(["2024-01-01","2024-01-02","2024-02-01"]),
        "t_min_c":[0,1,2],"t_max_c":[10,11,12],
        "t_avg_c":[5,6,7],"humidity_pct":[50,60,70],"rain_mm":[1,2,3],
    })
    m = monthly_table(df)
    assert len(m) == 2
    assert round(m.loc[0,"sum_rain_mm"],1) == 3.0

def test_compute_all_stats_sums():
    df = pd.DataFrame({
        "date": pd.to_datetime(["2024-01-01","2024-01-02"]),
        "t_min_c":[0,1],"t_max_c":[10,11],
        "t_avg_c":[5,6],"humidity_pct":[50,60],"rain_mm":[1,2],
    })
    s = compute_all_stats(df)
    assert s["rain_total_mm"] == 3.0
    assert s["coverage_days"] == 2