import pandas as pd
from src.quality import validate_and_clean

def test_impute_and_rules():
    df = pd.DataFrame({
        "date": pd.to_datetime(["2024-01-01","2024-01-02","2024-01-03"]),
        "t_min_c":[0,None,2], "t_max_c":[10,11,None],
        "humidity_pct":[50,110,None], "rain_mm":[None,None,1.0]
    })
    clean, qc = validate_and_clean(df)
    assert clean["t_min_c"].isna().sum() == 0
    assert clean["t_max_c"].isna().sum() == 0
    assert clean["humidity_pct"].isna().sum() == 0
    assert clean["rain_mm"].isna().sum() == 0