import pandas as pd

def load_weather(path: str, year: int | None = None) -> pd.DataFrame:
    df = pd.read_csv(path)
    df["date"] = pd.to_datetime(df["date"], format="%Y-%m-%d", errors="coerce")
    if year:
        df = df[df["date"].dt.year == year]
    return df