# Weather Data Analysis — University Assignment Package

This package contains a **realistic university-style assignment** with starter code, tests, data, and a complete spec.

## Quick start
```bash
python -m venv .venv
# Windows: .venv\Scripts\activate
source .venv/bin/activate
pip install -r requirements.txt
python -m src.analyze --input data/weather_daily.csv --outdir out --year 2024
pytest -q
```

Outputs are written to `out/` with figures under `out/figs/`.

## Files
- `ASSIGNMENT.md` — full specification, rubric, deliverables
- `data/weather_daily.csv` — 2024 synthetic daily data (366 rows)
- `src/` — implementation skeleton
- `tests/` — minimal correctness tests
- `requirements.txt` — pinned libs
- `report.md` — template to fill after running

## Academic integrity
Use this only as a sample. Cite data sources if you swap the dataset.